/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IgnoreJRERequirement;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

@IgnoreJRERequirement
public final class StreamSubject
extends Subject {
    private final FailureMetadata metadata;
    private final @Nullable Stream<?> actual;
    private final Supplier<@Nullable List<?>> listSupplier;

    StreamSubject(FailureMetadata metadata, @Nullable Stream<?> actual, Supplier<@Nullable List<?>> listSupplier) {
        super(metadata, actual);
        this.metadata = metadata;
        this.actual = actual;
        this.listSupplier = listSupplier;
    }

    StreamSubject(FailureMetadata metadata, @Nullable Stream<?> actual) {
        this(metadata, actual, Suppliers.memoize(StreamSubject.listCollector(actual)));
    }

    @Override
    protected String actualCustomStringRepresentation() {
        List asList;
        try {
            asList = (List)this.listSupplier.get();
        }
        catch (IllegalStateException e) {
            return "Stream that has already been operated upon or closed: " + this.actual();
        }
        return String.valueOf(asList);
    }

    @Deprecated
    public static Subject.Factory<StreamSubject, Stream<?>> streams() {
        return StreamSubject::new;
    }

    public void isEmpty() {
        this.checkThatContentsList().isEmpty();
    }

    public void isNotEmpty() {
        this.checkThatContentsList().isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.checkThatContentsList().hasSize(expectedSize);
    }

    public void contains(@Nullable Object element) {
        this.checkThatContentsList().contains(element);
    }

    public void doesNotContain(@Nullable Object element) {
        this.checkThatContentsList().doesNotContain(element);
    }

    public void containsNoDuplicates() {
        this.checkThatContentsList().containsNoDuplicates();
    }

    public void containsAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.checkThatContentsList().containsAnyOf(first, second, rest);
    }

    public void containsAnyIn(@Nullable Iterable<?> expected) {
        this.checkThatContentsList().containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAtLeast(@Nullable Object first, @Nullable Object second, Object ... rest) {
        return this.checkThatContentsList().containsAtLeast(first, second, rest);
    }

    @CanIgnoreReturnValue
    public Ordered containsAtLeastElementsIn(@Nullable Iterable<?> expected) {
        return this.checkThatContentsList().containsAtLeastElementsIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(Object ... varargs) {
        return this.checkThatContentsList().containsExactly(varargs);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(@Nullable Iterable<?> expected) {
        return this.checkThatContentsList().containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.checkThatContentsList().containsNoneOf(first, second, rest);
    }

    public void containsNoneIn(@Nullable Iterable<?> excluded) {
        this.checkThatContentsList().containsNoneIn(excluded);
    }

    public void isInStrictOrder() {
        this.checkThatContentsList().isInStrictOrder();
    }

    public void isInStrictOrder(Comparator<?> comparator) {
        this.checkThatContentsList().isInStrictOrder(comparator);
    }

    public void isInOrder() {
        this.checkThatContentsList().isInOrder();
    }

    public void isInOrder(Comparator<?> comparator) {
        this.checkThatContentsList().isInOrder(comparator);
    }

    @Override
    @Deprecated
    public void isEqualTo(@Nullable Object expected) {
        new StreamSubject(this.metadata.withMessage("%s", new Object[]{"Warning: Stream equality is based on object identity. To compare Stream contents, use methods like containsExactly."}), this.actual, this.listSupplier).superIsEqualTo(expected);
    }

    private void superIsEqualTo(@Nullable Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    @Deprecated
    public void isNotEqualTo(@Nullable Object unexpected) {
        if (this.actual() == unexpected) {
            this.failWithoutActual(Fact.fact("expected not to be", this.actualCustomStringRepresentationForPackageMembersToCall()), new Fact[0]);
            return;
        }
        super.isNotEqualTo(unexpected);
    }

    private IterableSubject checkThatContentsList() {
        return new IterableSubject(this.metadata, (Iterable)this.listSupplier.get(), "stream");
    }

    private static Supplier<@Nullable List<?>> listCollector(@Nullable Stream<?> actual) {
        return () -> actual == null ? null : (List)actual.collect(Collectors.toCollection(ArrayList::new));
    }
}

