/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.index.IndexEntry;
import org.dita.index.IndexEntryImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class IndexDitaProcessor {
    private static final String ATTR_START = "start";
    private static final String ATTR_END = "end";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String SORT_START = "[";
    private static final String SORT_END = "]";
    private DITAOTLogger logger;

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public List<IndexEntry> processIndexDitaNode(Node node, String parentValue) {
        IndexEntryImpl result;
        NodeList childNodes = node.getChildNodes();
        StringBuilder textValueBuffer = new StringBuilder();
        ArrayList<Node> contents = new ArrayList<Node>();
        StringBuilder sortStringBuffer = new StringBuilder();
        boolean startRange = node.getAttributes().getNamedItem(ATTR_START) != null;
        boolean endRange = node.getAttributes().getNamedItem(ATTR_END) != null;
        ArrayList<IndexEntry> childEntrys = new ArrayList<IndexEntry>();
        ArrayList<IndexEntry> seeEntry = new ArrayList<IndexEntry>();
        ArrayList<IndexEntry> seeAlsoEntry = new ArrayList<IndexEntry>();
        block4: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    contents.add(child);
                    Iterator val = child.getNodeValue();
                    if (null == val) continue block4;
                    textValueBuffer.append((String)((Object)val));
                    continue block4;
                }
                case 1: {
                    if (Constants.TOPIC_INDEXTERM.matches(child)) {
                        String currentTextValue = IndexDitaProcessor.normalizeTextValue(textValueBuffer.toString());
                        Iterator currentRefId = currentTextValue.isEmpty() ? "" : currentTextValue + ":";
                        childEntrys.addAll(this.processIndexDitaNode(child, parentValue + currentRefId));
                        continue block4;
                    }
                    if (Constants.INDEXING_D_INDEX_SORT_AS.matches(child)) {
                        List children = XMLUtils.toList((NodeList)child.getChildNodes());
                        for (Node sortChildNode : children) {
                            String text;
                            if (sortChildNode.getNodeType() != 3 || (text = sortChildNode.getNodeValue()) == null) continue;
                            sortStringBuffer.append(text);
                        }
                        continue block4;
                    }
                    if (Constants.INDEXING_D_INDEX_SEE.matches(child)) {
                        seeEntry.addAll(this.processIndexDitaNode(child, ""));
                        continue block4;
                    }
                    if (Constants.INDEXING_D_INDEX_SEE_ALSO.matches(child)) {
                        seeAlsoEntry.addAll(this.processIndexDitaNode(child, ""));
                        continue block4;
                    }
                    if (child.getNodeType() != 1) continue block4;
                    contents.add(child);
                    textValueBuffer.append(XMLUtils.getStringValue((Element)((Element)child)));
                }
            }
        }
        String textValue = IndexDitaProcessor.normalizeTextValue(textValueBuffer.toString());
        String sortString = sortStringBuffer.toString();
        if (textValue.contains(SORT_START) && textValue.contains(SORT_END) && sortString.length() == 0 && textValue.indexOf(SORT_START) < textValue.indexOf(SORT_END)) {
            sortString = textValue.substring(textValue.indexOf(SORT_START) + 1, textValue.indexOf(SORT_END));
            textValue = textValue.substring(0, textValue.indexOf(SORT_START));
        }
        if (!childEntrys.isEmpty() && !seeEntry.isEmpty()) {
            for (IndexEntry e : seeEntry) {
                this.logger.warn(MessageUtils.getMessage((String)"DOTA067W", (String[])new String[]{e.getFormattedString(), textValue}).toString());
            }
            seeEntry.clear();
        }
        if (!childEntrys.isEmpty() && !seeAlsoEntry.isEmpty()) {
            for (IndexEntry e : seeAlsoEntry) {
                this.logger.warn(MessageUtils.getMessage((String)"DOTA068W", (String[])new String[]{e.getFormattedString(), textValue}).toString());
            }
            seeAlsoEntry.clear();
        }
        if (!(result = new IndexEntryImpl(textValue, sortString.isEmpty() ? null : sortString, textValue, contents)).getValue().isEmpty() || endRange || startRange) {
            result.setStartRange(startRange);
            result.setEndsRange(endRange);
            if (startRange) {
                result.addRefID(node.getAttributes().getNamedItem(ATTR_START).getNodeValue());
            } else if (endRange) {
                result.addRefID(node.getAttributes().getNamedItem(ATTR_END).getNodeValue());
            } else {
                result.addRefID(IndexDitaProcessor.normalizeTextValue(parentValue + textValue + ":"));
            }
            if (!seeEntry.isEmpty()) {
                for (IndexEntry seeIndexEntry : seeEntry) {
                    result.addSeeChild(seeIndexEntry);
                }
                result.setSuppressesThePageNumber(true);
            }
            if (!seeAlsoEntry.isEmpty()) {
                for (IndexEntry seeAlsoIndexEntry : seeAlsoEntry) {
                    result.addSeeAlsoChild(seeAlsoIndexEntry);
                }
            }
            for (IndexEntry child : childEntrys) {
                result.addChild(child);
            }
            return Collections.singletonList(result);
        }
        return childEntrys;
    }

    @VisibleForTesting
    static String stripFormatting(String value) {
        int ltPos = value.indexOf(LT);
        int gtPos = value.indexOf(GT);
        if (ltPos == -1 && gtPos == -1) {
            return value;
        }
        if (ltPos == -1 || gtPos == -1 || ltPos > gtPos) {
            System.err.println("Possibly bad formatting in string \"" + value + "\"");
            return value;
        }
        return IndexDitaProcessor.stripFormatting(value.substring(0, ltPos) + value.substring(gtPos + 1));
    }

    @VisibleForTesting
    static String normalizeTextValue(String string) {
        if (null != string && !string.isEmpty()) {
            String res = string.replaceAll("[\\s\\n]+", " ").trim();
            res = res.replaceAll("[\\s]+$", "");
            return res;
        }
        return string;
    }
}

