/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.slf4j.Logger;

public final class LoggerListener
implements BuildListener {
    private static final Pattern FATAL_PATTERN = Pattern.compile("\\[\\w+F]\\[FATAL]");
    private static final Pattern ERROR_PATTERN = Pattern.compile("\\[\\w+E]\\[ERROR]");
    private static final Pattern WARN_PATTERN = Pattern.compile("\\[\\w+W]\\[WARN]");
    private static final Pattern INFO_PATTERN = Pattern.compile("\\[\\w+I]\\[INFO]");
    private static final Pattern DEBUG_PATTERN = Pattern.compile("\\[\\w+D]\\[DEBUG]");
    private final Logger logger;

    public LoggerListener(Logger logger) {
        this.logger = logger;
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        String message = event.getMessage();
        int level = FATAL_PATTERN.matcher(message).find() ? 0 : (ERROR_PATTERN.matcher(message).find() ? 0 : (WARN_PATTERN.matcher(message).find() ? 1 : (INFO_PATTERN.matcher(message).find() ? 2 : (DEBUG_PATTERN.matcher(message).find() ? 4 : event.getPriority()))));
        switch (level) {
            case 4: {
                this.logger.trace(message);
                break;
            }
            case 3: {
                this.logger.debug(message);
                break;
            }
            case 2: {
                this.logger.info(message);
                break;
            }
            case 1: {
                this.logger.warn(message);
                break;
            }
            default: {
                this.logger.error(message);
            }
        }
    }
}

