/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractDomFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MapMetaReader
extends AbstractDomFilter {
    private final Map<URI, Map<String, Element>> resultTable = new HashMap<URI, Map<String, Element>>();
    private static final Set<String> uniqueSet = Set.of(Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_SOURCE.matcher, Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_SEARCHTITLE.matcher);
    private static final Set<String> cascadeSet = Set.of(Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_METADATA.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_PUBLISHER.matcher);
    private static final Set<String> metaSet = Set.of(Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_SEARCHTITLE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_KEYWORDS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_RESOURCEID.matcher, Constants.TOPIC_DATA.matcher, Constants.TOPIC_DATA_ABOUT.matcher, Constants.TOPIC_FOREIGN.matcher, Constants.TOPIC_UNKNOWN.matcher);
    private static final List<String> metaPos = List.of(Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_SEARCHTITLE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_KEYWORDS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_RESOURCEID.matcher, Constants.TOPIC_DATA.matcher, Constants.TOPIC_DATA_ABOUT.matcher, Constants.TOPIC_FOREIGN.matcher, Constants.TOPIC_UNKNOWN.matcher, Constants.MAP_LINKTEXT.matcher, Constants.TOPIC_LINKTEXT.matcher, Constants.MAP_SHORTDESC.matcher, Constants.TOPIC_SHORTDESC.matcher, Constants.TOPIC_NAVTITLE.matcher, Constants.TOPIC_METADATA.matcher);
    private final Map<String, Element> globalMeta = new HashMap<String, Element>(16);
    private Document doc = null;
    private Document resultDoc;
    private URI filePath;

    public void setXmlUtils(XMLUtils xmlUtils) {
        this.resultDoc = xmlUtils.newDocument();
    }

    @Override
    public void read(File filename) throws DITAOTException {
        this.filePath = filename.toURI();
        this.globalMeta.clear();
        super.read(filename);
    }

    @Override
    public Document process(Document doc) {
        this.doc = doc;
        for (Element elem : XMLUtils.getChildElements(doc.getDocumentElement(), Constants.MAP_TOPICMETA)) {
            this.handleGlobalMeta(elem);
        }
        for (Element elem : XMLUtils.getChildElements(doc.getDocumentElement(), Constants.MAP_TOPICREF)) {
            this.handleTopicref(elem, this.globalMeta);
        }
        for (Element keyword : XMLUtils.getChildElements(doc.getDocumentElement(), Constants.TOPIC_KEYWORDS, true)) {
            this.removeIndexTermRecursive(keyword);
        }
        for (Element elem : XMLUtils.getChildElements(doc.getDocumentElement(), Constants.MAP_TOPICREF)) {
            this.collectTopicrefs(elem);
        }
        return doc;
    }

    private void collectTopicrefs(Element topicref) {
        URI hrefAttr = Optional.ofNullable(topicref.getAttributeNode("href")).map(Node::getNodeValue).map(URLUtils::toURI).orElse(null);
        String scopeAttr = XMLUtils.getCascadeValue(topicref, "scope");
        Attr formatAttr = topicref.getAttributeNode("format");
        Map<String, Element> current = Collections.emptyMap();
        boolean hasDitaTopicTarget = hrefAttr != null && DitaUtils.isLocalScope(scopeAttr) && this.isDitaFormat(formatAttr);
        for (Element elem : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF)) {
            this.collectTopicrefs(elem);
        }
        if (hasDitaTopicTarget) {
            for (Element elem : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICMETA)) {
                current = this.handleMeta(elem, Collections.emptyMap());
            }
        }
        if (!current.isEmpty() && hasDitaTopicTarget) {
            URI copytoAttr = Optional.ofNullable(topicref.getAttributeNode("copy-to")).map(Node::getNodeValue).map(URLUtils::toURI).map(URLUtils::stripFragment).orElse(null);
            URI rel = Objects.requireNonNullElse(copytoAttr, hrefAttr);
            URI topicPath = this.job.tempDirURI.relativize(this.filePath.resolve(rel));
            if (this.resultTable.containsKey(topicPath)) {
                Map<String, Element> previous = this.resultTable.get(topicPath);
                this.resultTable.put(topicPath, this.mergeMeta(previous, current, metaSet));
            } else {
                this.resultTable.put(topicPath, this.cloneElementMap(current));
            }
        }
    }

    private void removeIndexTermRecursive(Element parent) {
        if (parent == null) {
            return;
        }
        for (Element child : XMLUtils.getChildElements(parent)) {
            boolean hasEnd;
            boolean isIndexTerm = Constants.TOPIC_INDEXTERM.matches(child);
            boolean hasStart = !child.getAttribute("start").isEmpty();
            boolean bl = hasEnd = !child.getAttribute("end").isEmpty();
            if (isIndexTerm && (hasStart || hasEnd)) {
                parent.removeChild(child);
                continue;
            }
            this.removeIndexTermRecursive(child);
        }
    }

    private void handleTopicref(Element topicref, Map<String, Element> inheritance) {
        Map<String, Element> metas;
        boolean hasDitaTopicTarget;
        URI hrefAttr = Optional.ofNullable(topicref.getAttributeNode("href")).map(Node::getNodeValue).map(URLUtils::toURI).orElse(null);
        String scopeAttr = XMLUtils.getCascadeValue(topicref, "scope");
        Attr formatAttr = topicref.getAttributeNode("format");
        Map<String, Element> current = this.mergeMeta(Collections.emptyMap(), inheritance, cascadeSet);
        boolean bl = hasDitaTopicTarget = hrefAttr != null && DitaUtils.isLocalScope(scopeAttr) && this.isDitaFormat(formatAttr);
        if (hasDitaTopicTarget) {
            for (Element elem : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICMETA)) {
                current = this.handleMeta(elem, inheritance);
            }
        }
        for (Element elem : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF)) {
            this.handleTopicref(elem, current);
        }
        if (!current.isEmpty() && hasDitaTopicTarget && !(metas = this.cloneElementMap(current)).isEmpty()) {
            XMLUtils.getChildElement(topicref, Constants.MAP_TOPICMETA).ifPresent(topicref::removeChild);
            Element newMeta = this.doc.createElement(Constants.MAP_TOPICMETA.localName);
            newMeta.setAttribute("class", "-" + Constants.MAP_TOPICMETA.matcher);
            for (String metaPo : metaPos) {
                Node stub = metas.get(metaPo);
                if (stub == null) continue;
                for (Node child : XMLUtils.toList(stub.getChildNodes())) {
                    Node copy = topicref.getOwnerDocument().importNode(child, true);
                    newMeta.appendChild(copy);
                }
            }
            topicref.insertBefore(newMeta, topicref.getFirstChild());
        }
    }

    private boolean isDitaFormat(Attr formatAttr) {
        return formatAttr == null || "dita".equals(formatAttr.getNodeValue()) || "ditamap".equals(formatAttr.getNodeValue());
    }

    private Map<String, Element> cloneElementMap(Map<String, Element> current) {
        HashMap<String, Element> topicMetaTable = new HashMap<String, Element>(16);
        for (Map.Entry<String, Element> topicMetaItem : current.entrySet()) {
            Element copy = (Element)this.resultDoc.importNode(topicMetaItem.getValue(), true);
            topicMetaTable.put(topicMetaItem.getKey(), copy);
        }
        return topicMetaTable;
    }

    private Map<String, Element> handleMeta(Element meta, Map<String, Element> inheritance) {
        HashMap<String, Element> topicMetaTable = new HashMap<String, Element>(16);
        this.getMeta(meta, topicMetaTable);
        return this.mergeMeta(topicMetaTable, inheritance, cascadeSet);
    }

    private void getMeta(Element meta, Map<String, Element> topicMetaTable) {
        for (Element elem : XMLUtils.getChildElements(meta)) {
            Node copy;
            String classValue = elem.getAttribute("class");
            String metaKey = classValue.substring(1, classValue.indexOf(" ", classValue.indexOf("/")) + 1);
            if (Constants.TOPIC_METADATA.matches(classValue)) {
                this.getMeta(elem, topicMetaTable);
                continue;
            }
            if (topicMetaTable.containsKey(metaKey)) {
                copy = this.resultDoc.importNode(elem, true);
                topicMetaTable.get(metaKey).appendChild(copy);
                continue;
            }
            if (Constants.TOPIC_NAVTITLE.matches(classValue)) {
                String locktitleAttr = Optional.ofNullable(((Element)meta.getParentNode()).getAttributeNode("locktitle")).map(Node::getNodeValue).orElse("no");
                elem.setAttributeNS("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "dita-ot:locktitle", locktitleAttr);
            }
            copy = this.resultDoc.importNode(elem, true);
            Element stub = this.resultDoc.createElement("stub");
            stub.appendChild(copy);
            topicMetaTable.put(metaKey, stub);
        }
    }

    private Map<String, Element> mergeMeta(Map<String, Element> topicMetaTable, Map<String, Element> inheritance, Set<String> enableSet) {
        HashMap<String, Element> res = new HashMap<String, Element>(topicMetaTable);
        for (String key : enableSet) {
            Element inheritStub;
            if (!inheritance.containsKey(key)) continue;
            Element value = inheritance.get(key);
            if (uniqueSet.contains(key)) {
                if (res.containsKey(key)) continue;
                res.put(key, value);
                continue;
            }
            if (!res.containsKey(key)) {
                res.put(key, value);
                continue;
            }
            Element stub = (Element)res.get(key);
            if (stub != (inheritStub = value)) {
                for (Element child : XMLUtils.getChildElements(inheritStub)) {
                    Element item = (Element)stub.getOwnerDocument().importNode(child, true);
                    stub.appendChild(item);
                }
            }
            res.put(key, stub);
        }
        return Collections.unmodifiableMap(res);
    }

    private void handleGlobalMeta(Element metadata) {
        for (Element elem : XMLUtils.getChildElements(metadata)) {
            Attr classAttr = elem.getAttributeNode("class");
            if (classAttr == null) continue;
            String classValue = classAttr.getNodeValue();
            String metaKey = classValue.substring(1, classValue.indexOf(" ", classValue.indexOf("/")) + 1);
            if (Constants.TOPIC_METADATA.matches(classValue)) {
                this.handleGlobalMeta(elem);
                continue;
            }
            if (cascadeSet.contains(metaKey) && this.globalMeta.containsKey(metaKey)) {
                this.globalMeta.get(metaKey).appendChild(this.resultDoc.importNode(elem, true));
                continue;
            }
            if (!cascadeSet.contains(metaKey)) continue;
            Element stub = this.resultDoc.createElement("stub");
            stub.appendChild(this.resultDoc.importNode(elem, true));
            this.globalMeta.put(metaKey, stub);
        }
    }

    public Map<URI, Map<String, Element>> getMapping() {
        return Collections.unmodifiableMap(this.resultTable);
    }
}

