/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Job;
import org.dita.dost.writer.AbstractWriter;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class AbstractXMLFilter
extends XMLFilterImpl
implements AbstractWriter {
    protected DITAOTLogger logger;
    protected Job job;
    protected URI currentFile;
    protected final Map<String, String> params = new HashMap<String, String>();

    @Override
    public void write(File filename) throws DITAOTException {
        assert (filename.isAbsolute());
        this.job.getStore().transform(filename.toURI(), Collections.singletonList(this));
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    public void setCurrentFile(URI currentFile) {
        assert (currentFile.isAbsolute());
        this.currentFile = currentFile;
    }

    public void setParam(String name, String value) {
        this.params.put(name, value);
    }
}

