/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ProfilingFilter
extends AbstractXMLFilter {
    private boolean exclude;
    private int level;
    private QName[][] props;
    private List<FilterUtils> filterUtils;
    private boolean elementOutput;
    private final Map<String, String> prefixes = new HashMap<String, String>();
    private boolean lastElementExcluded = false;
    private final Deque<Set<FilterUtils.Flag>> flagStack = new LinkedList<Set<FilterUtils.Flag>>();
    private final boolean doFlag;

    public ProfilingFilter() {
        this(true);
    }

    public ProfilingFilter(boolean doFlag) {
        this.doFlag = doFlag;
    }

    public void setFilterUtils(FilterUtils filterUtils) {
        this.filterUtils = Collections.singletonList(filterUtils);
    }

    public void setFilterUtils(List<FilterUtils> filterUtils) {
        this.filterUtils = filterUtils;
    }

    public boolean hasElementOutput() {
        return this.elementOutput;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        DitaClass cls;
        Set flags = null;
        DitaClass ditaClass = cls = atts.getValue("class") != null ? DitaClass.getInstance(atts) : DitaClass.getInstance("");
        if (cls.isValid() && (Constants.TOPIC_TOPIC.matches(cls) || Constants.MAP_MAP.matches(cls))) {
            String domains = atts.getValue("domains");
            if (domains != null) {
                this.props = StringUtils.getExtProps(domains);
            } else {
                String specializations = atts.getValue("specializations");
                if (specializations != null) {
                    this.props = StringUtils.getExtPropsFromSpecializations(specializations);
                }
            }
        }
        if (this.exclude) {
            ++this.level;
        } else if (cls.isValid() && this.filterUtils.stream().anyMatch(f -> f.needExclude(atts, this.props))) {
            this.exclude = true;
            this.level = 0;
        } else {
            this.elementOutput = true;
            for (Map.Entry<String, String> prefix : this.prefixes.entrySet()) {
                this.getContentHandler().startPrefixMapping(prefix.getKey(), prefix.getValue());
            }
            this.prefixes.clear();
            this.getContentHandler().startElement(uri, localName, qName, atts);
            if (this.doFlag && cls.isValid()) {
                flags = this.filterUtils.stream().flatMap(f -> f.getFlags(atts, this.props).stream()).map(f -> f.adjustPath(this.currentFile, this.job)).collect(Collectors.toSet());
                for (FilterUtils.Flag flag : flags) {
                    flag.writeStartFlag(this.getContentHandler());
                }
            }
        }
        if (this.doFlag) {
            this.flagStack.push(flags);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Set<FilterUtils.Flag> flags;
        if (this.doFlag && (flags = this.flagStack.pop()) != null) {
            for (FilterUtils.Flag flag : flags) {
                flag.writeEndFlag(this.getContentHandler());
            }
        }
        this.lastElementExcluded = this.exclude;
        if (this.exclude) {
            if (this.level > 0) {
                --this.level;
            } else {
                this.exclude = false;
            }
        } else {
            this.getContentHandler().endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().endDocument();
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.lastElementExcluded) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.exclude = false;
        this.level = 0;
        this.props = null;
        this.getContentHandler().startDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixes.put(prefix, uri);
    }
}

