/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.spi.DefaultElementVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.DependencyVerifier;

final class ElementMerger
extends DefaultElementVisitor<Void> {
    private final DependencyVerifier verifier = new DependencyVerifier();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementMerger(Binder binder) {
        this.binder = binder;
    }

    @Override
    public <T> Void visit(Binding<T> binding) {
        Key<T> key = binding.getKey();
        if (!this.localKeys.contains(key)) {
            if (Boolean.TRUE.equals(binding.acceptTargetVisitor(this.verifier))) {
                this.localKeys.add(key);
                binding.applyTo(this.binder);
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

